/** Плагин поперемненого затухания  элементов "шапки" сайта jquery.fadeswitcher.js
 *  Copyright (c) 2011 Земсков Илья (http://twitter.com/vimruler)
 *  Dual licensed under the MIT and GPL licenses
 */

(function($){
	
    $.fn.fadeswitcher = function(options){

    	return this.each(function(){
	   
            options = $.extend({
					name :			'fadeswitcher',
					imgclass :		'.imglink',
					altcopy :		true,
					altcopyclass :	'.services_name',
					speed:			500,
					times:			2, // сколько раз мигать
					timeout:		3000,
					autorun:		true
				},options);
       
			var $this = $(this), 
				current = -1, 
				intervalID = 0,
				altto = $(options.altcopyclass),
				pics = $(options.imgclass),
				count = pics.length - 1,
				run = false,
					
				methods = {
					init: function(){
						pics.stop(true,true).show();//pics.css('opacity', 1); // делаем всех видимыми
							
						$this.bind('mousemove.fadeswitcher',function(){
							methods.stop();
						});
							
						$this.bind('mouseleave.fadeswitcher',function(){
							methods.start();
						});
						
						pics.bind('mouseleave.fadeswitcher',function(){
							altto.text('');
						});
						
						pics.bind('mousemove',function(){
							var txt = $(this).attr('alt');
							$(options.altcopyclass).text( txt );
						});
							
						if(options.autorun) methods.start();
					},
					start: function(){
						intervalID = setInterval(function(){methods.next();},options.timeout);   	
						run = true;
					},
					stop: function(){
						if(run){ 
							altto.text('');
							clearInterval(intervalID);
						}
						pics.show();
						run = false;
					},
					next: function(){
							
						altto.text('');
							
						current++;
						if(current >= count) current = -1;
							
						altto.text( pics.eq(current).attr('alt') );
							
						pics.eq(current).show("pulsate", {times: options.times}, options.speed);
					}
				};
				
			methods.init();
    	});
    };
})(jQuery);